import java.io.*;

public class Scanner {
    /**
     *Tato trida vzdy cte o jeden znak napred, takze prvni uz ctu v konstruktoru
     */
    public Scanner(Reader inp) {
        this.inp = new LineNumberReader(inp);
        getch();
    }
    public String getStringAttr(){
	return stringAttr;
    }
    public int getNumberAttr(){
	return numberAttr;
    }
    public int nextToken(){
        /**
         *Zkousi dokud neco nerozpozna, minimalne konec souboru
         */
        
	for(;;) {
            //Nejprve preskoci bile misto
            skipSpaces();
            //Pak preskoci poznamku (v teto implementaci nepreskoci \n, ale tento
            //znak nic neznamena, takze bude preskocen v dalsim cyklu.
            skipNote();
            //konec souboru
            if( isEof ) return Tokens.EOF;
            //je li aktualne cteny znak pismeno, cteme identifikator nebo klicove slova
            if( Character.isLetter(ch) ) {
                StringBuffer buf = new StringBuffer();
		do {
                    buf.append(ch);
                    getch();
		} while( !isEof && Character.isLetterOrDigit(ch) );
		stringAttr = buf.toString();
                //Test, zdali nejde o klicove slovo
		if( stringAttr.compareToIgnoreCase("div") == 0 ) return Tokens.DIV;
		if( stringAttr.compareToIgnoreCase("mod") == 0 ) return Tokens.MOD;
                return Tokens.IDENT;
            }
            //je li prvni cislice, jde o cislo
            if( Character.isDigit(ch) ) {
                StringBuffer buf = new StringBuffer();
		do {
                    buf.append(ch);
                    getch();
		} while( !isEof && Character.isDigit(ch) );
                numberAttr = Integer.parseInt(buf.toString());
                return Tokens.NUMBER;
            }
            // pokude tento znak neni ani cislo ani identifikator(nebo klic. slovo)
            //je to bud +,-,*,... nebo nejake smeti, ktere je potreba preskocit.
            //V tom pripade zacne cely cyklus znovu.
            char tmp=ch;
            getch();
            if (tmp=='+') return Tokens.PLUS;
            if (tmp=='-') return Tokens.MINUS;
            if (tmp=='*') return Tokens.KRAT;
            if (tmp=='/') return Tokens.DELENO;
            if (tmp==')') return Tokens.PZAV;
            if (tmp=='(') return Tokens.LZAV;
            if (tmp==';') return Tokens.STREDNIK;
            if (tmp==',') return Tokens.CARKA;
	}
    }
    /**
     *Preskoci "bile" znaky
     */
    private void skipSpaces(){
        while( !isEof && Character.isWhitespace(ch) ) 
            getch();
    }
    /**
     *Preskoci poznamku, a pripadne bile misto za ni.
     */
    private void skipNote(){
        if( ch == '\'' ) {
            do {
                getch();
            } while( !isEof && ch != '\n');
        }
        skipSpaces();
    }
    /**
     *Cte ze vstupu jeden znak.
     */
    private void getch(){
	int c;
	try { 
            c = inp.read();
	} catch( IOException e ) {
            c = -1;
	}
	isEof = c < 0;
	ch = (char)c;
    }
    private LineNumberReader inp;
    private boolean isEof = false;
    private char ch;
    private String stringAttr;
    private int numberAttr;
}

