package lab5;

public class Scanner {

    public Scanner(String inp) {
        this.input = inp;
        position = 0;
    }

    public Token nextToken() {
        skipSpaces();
        if (isEol) {
            return Token.EOL;
        }
        if (Character.isDigit(getChar())) {
            while (!isEol && Character.isDigit(getChar())) {
                nextChar();
            }
            return Token.NUMBER;
        }
        char tmp = getChar();
        nextChar();
        if (tmp == '+') {
            return Token.PLUS;
        }
        if (tmp == '-') {
            return Token.MINUS;
        }
        if (tmp == '*') {
            return Token.MULTIPLY;
        }
        if (tmp == '/') {
            return Token.DIVIDE;
        }
        if (tmp == ')') {
            return Token.RBRACKET;
        }
        if (tmp == '(') {
            return Token.LBRACKET;
        }
        System.err.println("Doslo k chybe pri lexikalni analze!");
        return Token.ERROR;
    }

    private void skipSpaces() {
        while (!isEol && Character.isWhitespace(getChar())) {
            nextChar();
        }
    }

    private void nextChar() {
        if (position + 1 >= input.length()) {
            isEol = true;
        } else {
            position++;
        }
    }

    private char getChar() {
        return input.charAt(position);
    }

    private String input;
    private int position;
    private boolean isEol = false;
}
