/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import grammar.Grammar;
import grammar.GrammarException;
import grammar.GrammarImpl;
import grammar.Nonterminal;
import grammar.Rule;
import grammar.Terminal;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;

public final class GrammarReader {
    private static final int SYM_NT = 78;
    private static final int SYM_T = 84;
    private static final int SYM_EOF = -1;
    private LineNumberReader inp;
    private int ch;
    private String attr;

    public GrammarReader(Reader input) {
        this.inp = new LineNumberReader(input);
        this.inp.setLineNumber(1);
    }

    public Grammar read() throws GrammarException, IOException {
        GrammarImpl grammar = new GrammarImpl();
        this.ch = this.inp.read();
        int sym = this.getSym();
        while (sym != -1) {
            if (sym != 78) {
                this.error("Na leve strane pravidla se ocekava nonterminal");
            }
            Nonterminal lhs = grammar.addNonterminal(this.attr.toString());
            if (grammar.getStartNonterminal() == null) {
                grammar.setStartNonterminal(lhs);
            }
            if ((sym = this.getSym()) != 58) {
                this.error("Ocekava se dvojtecka");
            }
            do {
                sym = this.getSym();
                Rule rule = new Rule(lhs);
                while (sym == 78 || sym == 84) {
                    if (sym == 78) {
                        Nonterminal nt = grammar.addNonterminal(this.attr);
                        rule.addSymbol(nt);
                        sym = this.getSym();
                        continue;
                    }
                    if (sym != 84) continue;
                    Terminal t = grammar.addTerminal(this.attr);
                    rule.addSymbol(t);
                    sym = this.getSym();
                }
                lhs.addRule(rule);
            } while (sym == 124);
            if (sym != 59) {
                this.error("Ocekava se strednik");
            }
            sym = this.getSym();
        }
        return grammar;
    }

    private void error(String msg) throws GrammarException {
        throw new GrammarException(msg, this.inp.getLineNumber());
    }

    private int getSym() throws IOException {
        while (true) {
            if (this.ch < 0) {
                return -1;
            }
            if (Character.isWhitespace((char)this.ch)) {
                this.ch = this.inp.read();
                continue;
            }
            if (this.ch != 123) break;
            do {
                this.ch = this.inp.read();
            } while (this.ch >= 0 && this.ch != 125);
            if (this.ch < 0) continue;
            this.ch = this.inp.read();
        }
        if (Character.isLetter((char)this.ch)) {
            StringBuffer buf = new StringBuffer();
            do {
                buf.append((char)this.ch);
                this.ch = this.inp.read();
            } while (this.ch > 0 && Character.isLetterOrDigit((char)this.ch));
            this.attr = buf.toString();
            return Character.isLowerCase(this.attr.charAt(0)) ? 84 : 78;
        }
        int sym = this.ch;
        this.ch = this.inp.read();
        return sym;
    }
}

