/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import grammar.Grammar;
import grammar.Nonterminal;
import grammar.Rule;
import grammar.Symbol;
import grammar.Terminal;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarImpl
implements Grammar {
    private Map<String, Terminal> terminals = new TreeMap<String, Terminal>();
    private Map<String, Nonterminal> nonterminals = new TreeMap<String, Nonterminal>();
    private Nonterminal startNonterminal;

    @Override
    public Collection<Terminal> getTerminals() {
        return this.terminals.values();
    }

    public Terminal addTerminal(String name) {
        Terminal t = this.terminals.get(name);
        if (t == null) {
            t = new Terminal(name);
            this.terminals.put(name, t);
        }
        return t;
    }

    @Override
    public Collection<Nonterminal> getNonterminals() {
        return this.nonterminals.values();
    }

    public Nonterminal addNonterminal(String name) {
        Nonterminal nt = this.nonterminals.get(name);
        if (nt == null) {
            nt = new Nonterminal(name);
            this.nonterminals.put(name, nt);
        }
        return nt;
    }

    @Override
    public Collection<Rule> getRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Nonterminal nt : this.getNonterminals()) {
            for (Rule r : nt.getRules()) {
                rules.add(r);
            }
        }
        return rules;
    }

    public void addRule(Rule rule) {
        rule.getLHS().addRule(rule);
    }

    @Override
    public Nonterminal getStartNonterminal() {
        return this.startNonterminal;
    }

    public void setStartNonterminal(Nonterminal start) {
        this.startNonterminal = start;
    }

    @Override
    public void dump(PrintStream out) {
        out.print("Terminalni symboly:");
        for (Terminal t : this.getTerminals()) {
            out.print(" " + t.getName());
        }
        out.println();
        out.print("Neterminalni symboly:");
        for (Nonterminal nt : this.getNonterminals()) {
            out.print(" " + nt.getName());
        }
        out.println();
        out.println("Startovaci nonterminal: " + this.getStartNonterminal().getName());
        out.println("Pravidla:");
        int i = 0;
        for (Rule rule : this.getRules()) {
            out.print("[" + ++i + "] " + rule.getLHS().getName() + " -> ");
            Iterator i_rhs = rule.getRHS();
            while (i_rhs.hasNext()) {
                Symbol s = (Symbol)i_rhs.next();
                out.print(s.getName() + " ");
            }
            out.println();
        }
    }
}

