package grammarnetbeans;

import grammar.*;
import java.util.*;

/** Implementace v�po�t� nad gramatikou
 */
public class GrammarOps {

    /** Vytvori instanci objektu a provede vypocet */
    public GrammarOps(Grammar g) {
        this.g = g;
        compute_empty();
    }

    /** Vrati mnozinu nonterminalu generujicich prazdne slovo
     *  @return Mnozina symbolu typu Nonterminal.
     */
    public Set<Nonterminal> getEmptyNonterminals() {
        return emptyNonterminals;
    }

    /** Vypocet mnoziny nonterminalu generujicich prazdne slovo.
     */
    private void compute_empty() {
        emptyNonterminals = new TreeSet<Nonterminal>();
        int delka;
        do {
            delka = emptyNonterminals.size();
            for (Rule rule : g.getRules()) {
                boolean test = true;
                for (Symbol s : rule.getRHS()) {
                    if (s instanceof Terminal
                            || !emptyNonterminals.contains(s)) {
                        test = false;
                    }
                }
                if (test) {
                    emptyNonterminals.add(rule.getLHS());
                }
            }
        } while (delka != emptyNonterminals.size());
    }
    /** Gramatika */
    Grammar g;
    /** Mnozina nonterminalu generujicich prazdny retezec */
    Set<Nonterminal> emptyNonterminals;
}
