import java.io.*;

public class Scanner {
  /**
   *Tato trida vzdy cte o jeden znak napred, takze prvni uz ctu v konstruktoru
   */
  public Scanner(String inp) {
    this.inp = inp;
    poz = 0;
  }

  public int nextToken() {
    skipSpaces();
    if (isEol) {
      return Tokens.EOL;
    }
    //je li prvni cislice, jde o cislo
    if (Character.isDigit(getChar())) {
      int start=poz;
      while (!isEol && Character.isDigit(getChar())) nextChar();
      int end=poz;
      value=Integer.parseInt(inp.substring(start,end));
      return Tokens.NUMBER;
    }
    char tmp=getChar();
    nextChar();
    if (tmp == '+') {
      return Tokens.PLUS;
    }
    if (tmp == '-') {
      return Tokens.MINUS;
    }
    if (tmp == '*') {
      return Tokens.KRAT;
    }
    if (tmp == '/') {
      return Tokens.DELENO;
    }
    if (tmp == ')') {
      return Tokens.PZAV;
    }
    if (tmp == '(') {
      return Tokens.LZAV;
    }
    System.err.println("Doslo k chybe pri lexikalni analze!");
    return -1;
  }

  /**
   *Preskoci "bile" znaky
   */
  private void skipSpaces() {
    while (!isEol && Character.isWhitespace(getChar())) {
      nextChar();
    }
  }

  private void nextChar() {
    if (poz + 1 >= inp.length()) {
      poz++;
      isEol = true;
    }
    else {
      poz++;
    }
  }

  private char getChar() {
    return inp.charAt(poz);
  }
  public int getValue() {
      return value;
  }
  private int value;
  private String inp;
  private int poz;
  private boolean isEol = false;
}
